/// <reference path="jquery-1.3.2-vsdoc.js" />

var itineraryType;
var itineraryPoints;
var itineraryMap;
var itineraryDrivingDirections;
var itineraryRouteCurrentIndex = -1;

$(document).ready(function () {
    // ajax bulk add
    updateModelOnClickLink(
        $("span.bulkAdd a"),
        function (url) { return true; },
        function (data) {
            var bulkAdd = $("span.bulkAdd").empty();
            bulkAdd.append($("<span>The activities have been added to <a href='" + baseUrl + "'>your current itinerary</a></span>"));
        }
    );

    // load itineraty map
    if (rawPoints.length > 1) {
        itineraryPoints = parsePoints(rawPoints);
        itineraryMap = new VEMap('itineraryRouteMap');
        itineraryMap.SetDashboardSize(VEDashboardSize.Small);
        itineraryMap.LoadMap();
        $("#itineraryDrivingSelector").click(function () { calculateRoute(itineraryPoints, 0); });
        $("#itineraryWalkingSelector").click(function () { calculateRoute(itineraryPoints, 1); });
        calculateRoute(itineraryPoints, 0);
    }
});

function calculateRoute(itineraryPoints, type) {
    if (itineraryType == type) return;
    itineraryType = type;
    
    $("#itineraryMap div.loading").html("Calculating Directions...");
    $("#itineraryRouteDetails").empty();
    $("#itineraryRouteMap").css("visibility", "hidden");
    $("#travelEstimate").html("travel time");

    $("#itineraryDrivingSelector")[0].className = type == 0 ? "selected" : "";
    $("#itineraryWalkingSelector")[0].className = type == 1 ? "selected" : "";
    $("#itineraryRouteSelector").show();

    var options = new VERouteOptions();
    options.DistanceUnit = VERouteDistanceUnit.Mile;
    options.DrawRoute = true;
    options.RouteMode = type == 0 ? VERouteMode.Driving : VERouteMode.Walking;
    options.SetBestMapView = true;
    options.RouteOptimize = VERouteOptimize.MinimizeDistance;
    options.RouteCallback = calculateRouteResult;
    itineraryMap.GetDirections(itineraryPoints, options);
}

function calculateRouteResult(drivingDirections) {
    itineraryDrivingDirections = drivingDirections;
    $("ol.activities li p.routeEstimate").remove();     // cleanup
    
    var $ul = $("<ul></ul>");

    for (var i = 0; i < drivingDirections.RouteLegs.length; i++) {
        var route = drivingDirections.RouteLegs[i];

        // route estimate in activity list
        $("<p></p>").append("Travel estimated time: " + Math.round(route.Time / 60) + " minutes.")
                    .addClass("routeEstimate")
                    .appendTo($("ol.activities li")[i])
                    .attr("index", i.toString())
                    .bind("mouseover", itineraryRouteMouseOver)
                    .bind("mouseout", itinieraryRouteMouseOut)
                    .hide().slideDown()

        // route details
        var $li = $("<li></li>");
        $li.append($("<h4></h4>").append("From " + rawPoints[i].name + " to " + rawPoints[i + 1].name).append("<em> - " + Math.round(route.Time / 60) + " minutes, " + Math.round(route.Distance * 10) / 10 + " miles</em>"))
           .attr("index", i.toString())
           .appendTo($ul);
        var $ulRoute = $("<ol></ol>").appendTo($li);
        var items = route.Itinerary.Items;
        for (var n = 0; n < items.length; n++) {
            var item = items[n];
            var $liRoute = $("<li></li>").append(item.Text).appendTo($ulRoute);
            var miles = Math.round(item.Distance * 10) / 10
            if (n == items.length - 1) {
                $liRoute.empty().append($("<strong></strong>").append("Arrive to " + rawPoints[i + 1].name));
            } else if (miles > 0) {
                $liRoute.append(" - " + Math.round(item.Time / 60) + " minutes, " + miles + " miles");
            }

            item.Shape.Hide();
        }

        $li.bind("mouseover", itineraryRouteMouseOver)
           .bind("mouseout", itinieraryRouteMouseOut);
    }

    resetItineraryRouteIcons();
    
    $ul.appendTo($("#itineraryRouteDetails"));
    $("#itineraryRouteMap").css("visibility", "");
    
    $("#travelEstimate").html(Math.round(drivingDirections.Time / 60) + " minutes of " + $("#travelEstimate").html());
}

function itineraryRouteMouseOver() {
    var index = parseInt($(this).attr("index"), 10);

    if (index == itineraryRouteCurrentIndex) return;
    itineraryRouteCurrentIndex = index;

    $("#itineraryRouteDetails ul > li")[index].className = "selected";

    for (var i = 0; i < itineraryDrivingDirections.RouteLegs.length; i++) {
        var route = itineraryDrivingDirections.RouteLegs[i];
        if (i == index) {
            for (var n = 0; n < route.Itinerary.Items.length; n++) {
                route.Itinerary.Items[n].Shape.SetCustomIcon("http://dev.virtualearth.net/mapcontrol/v6.2/i/bin/6.2.2008082210001.41/pins/RedCircle" + (n + 1) + ".gif");
                route.Itinerary.Items[n].Shape.Show();
            }
        } else {
            for (var n = 0; n < route.Itinerary.Items.length; n++) route.Itinerary.Items[n].Shape.Hide();
        }
    }
}

function resetItineraryRouteIcons() {

    itineraryRouteCurrentIndex = -1;
    $("#itineraryRouteDetails ul li").removeClass("selected");

    for (var i = 0; i < itineraryDrivingDirections.RouteLegs.length; i++) {
        var route = itineraryDrivingDirections.RouteLegs[i];
        var letter = String.fromCharCode(65 + i);

        route.Itinerary.Items[0].Shape.SetCustomIcon(baseUrl + "Content/Images/Maps/mapicon_" + letter + ".gif");
        route.Itinerary.Items[0].Shape.Show();

        for (var n = 1; n < route.Itinerary.Items.length; n++) {
            route.Itinerary.Items[n].Shape.Hide();
        }
    }

    var lastRoute = itineraryDrivingDirections.RouteLegs[itineraryDrivingDirections.RouteLegs.length - 1];
    var lastItem = lastRoute.Itinerary.Items[lastRoute.Itinerary.Items.length - 1];
    lastItem.Shape.SetCustomIcon(baseUrl + "Content/Images/Maps/mapicon_" + String.fromCharCode(65 + itineraryDrivingDirections.RouteLegs.length) + ".gif");
    lastItem.Shape.Show();
}

function itinieraryRouteMouseOut() {
    var index = parseInt($(this).attr("index"), 10);
    if (itineraryRouteCurrentIndex != index) return;
    resetItineraryRouteIcons();
}

// Helper functions
function parsePoints(itineraryPoints) {
    var parsedPoints = [];
    for (var i = 0; i < itineraryPoints.length; i++) parsedPoints.push(parsePoint(itineraryPoints[i].point));
    return parsedPoints;
}

function parsePoint(sPoint) {
    // POINT (-122.252958559758 47.6248758581263)
    var lon = sPoint.split(' ')[1].split('(')[1];
    var lat = sPoint.split(' ')[2].split(')')[0];
    return new VELatLong(parseFloat(lat), parseFloat(lon));
}